<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "//www.w3.org/TR/html4/strict.dtd">
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <title>Products Excel Export</title>
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('images/favicon.ico')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Fonts -->
    <!-- General CSS Files -->
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css"/>
</head>
<body>
<table width="100%" cellspacing="0" cellpadding="10" style="margin-top: 40px;">
    <thead>
    <tr style="background-color: dodgerblue;">
        <th style="width: 200%"><?php echo e(__('messages.pdf.product')); ?></th>   
        <th style="width: 200%"><?php echo e(__('messages.pdf.code')); ?></th>
        <th style="width: 200%"><?php echo e(__('messages.pdf.brand')); ?></th>
        <th style="width: 200%"><?php echo e(__('messages.pdf.price')); ?></th>
        <th style="width: 200%"><?php echo e(__('messages.pdf.product_unit')); ?></th>
        <th style="width: 200%"><?php echo e(__('messages.pdf.in_stock')); ?></th>
        <th style="width: 200%"><?php echo e(__('messages.pdf.created_on')); ?></th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr align="center">
            <td><?php echo e($product->name); ?></td>
            <td><?php echo e($product->code); ?></td>
            <td><?php echo e($product->brand->name); ?></td>
            <td><?php echo e($product->product_price); ?></td>
            <td>
                <?php
                $productUnitName = App\Models\BaseUnit::where('id',$product->product_unit)->value('name');
                ?>
                <?php echo e($productUnitName); ?>

            </td>
            <td>
                <?php
                $totalQuantity = App\Models\Managestock::where('product_id', $product->id)->sum('quantity');
                ?>
                <?php echo e($totalQuantity); ?>

            </td>
            <td><?php echo e(\Carbon\Carbon::parse($product->created_at)->isoFormat('Do MMM, YYYY')); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\resources\views/excel/product-excel-export.blade.php ENDPATH**/ ?>